require 'rspec'
require 'watir-webdriver'
require 'page-object'

require 'common'
require 'login'
require 'loginLogout'
require 'table'
require 'modal'
require 'DriverUtility'
require 'DBUtility'
require 'DateUtility'
require 'MongoUtility'
require 'rspec_helper'
require 'base'
require 'varUtility/manage_settings/direct_scheduling'
require 'varUtility/manage_settings/request_settings'
require 'varUtility/error_validation'
require 'varUtility/landing'
require 'vaToolSet/launchpad'
require 'varUtility/manage_settings'
require 'vaToolSet/userMenu'

class VarUtility_PageObject
  include PageObject

  def initialize(driver)
    @driver = driver
  end

  def common
    Common.new(@driver)
  end

  def login
    Login.new(@driver)
  end

  def loginLogout
    LoginLogout.new(@driver)
  end

  def table
    Table.new(@driver)
  end

  def base
    Base.new(@driver)
  end

  def direct_scheduling
    Direct_Scheduling.new(@driver)
  end

  def request_setting
    Request_Settings.new(@driver)
  end

  def error
    Error_Validation.new(@driver)
  end

  def landing
    Landing.new(@driver)
  end

  def launchpad
    Launchpad.new(@driver)
  end

  def manage_setting
    Manage_Settings.new(@driver)
  end

  def modal
    Modal.new(@driver)
  end

  def userMenu
    UserMenu.new(@driver)
  end

  def accessVarUtility
    AccessVarUtility.new(@driver)
  end

end